/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.allsky.Action;
import cds.allsky.BuilderCheckCode;
import cds.allsky.Context;
import cds.fits.Fits;
import java.io.File;

public class BuilderUpdateDataSum
extends BuilderCheckCode {
    public BuilderUpdateDataSum(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.UPDATEDATASUM;
    }

    @Override
    protected void validateContextMore() throws Exception {
        if (this.format.indexOf("fits") < 0) {
            throw new Exception("No Fits tiles for this HiPS!");
        }
    }

    @Override
    public void run() throws Exception {
        this.context.loadProperties();
        this.scanDir(new File(this.context.getOutputPath()), "fits");
        this.context.writePropertiesFile();
        this.context.info("All DATASUM generated/updated");
    }

    @Override
    protected void updateInfo(File f, BuilderCheckCode.Info info) throws Exception {
        super.updateInfo(f, info);
        String filename = f.getAbsolutePath();
        Fits fits = new Fits();
        fits.loadFITS(filename);
        fits.addDataSum();
        fits.writeFITS(filename);
    }
}

